/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpEngine;

import ibm.nways.analysis.dpEngine.HistoryTimer;
import java.io.Serializable;

public class DpeConfig
implements Serializable {
    public boolean writeToFile;
    public int maxConsecutiveFailures;
    public int historySize;
    public int internalHistorySize;
    public float autoThresholdLevel;
    public int minTimeBetweenSaves;
    public int maxTimeBetweenSaves;
    public int validSampleInterval;
    public float historyThreshold;
    public int maxNotifyListSize;
    public boolean sendHistoryWithEvent;
    public HistoryTimer historyTimer;
    public boolean useSysUpTime = false;
    public float minValueVariationPercent;

    public DpeConfig(boolean bl, int n, int n2, int n3, float f, int n4, int n5, int n6, float f2, int n7, boolean bl2) {
        this(bl, n, n2, n3, f, n4, n5, n6, f2, n7, bl2, null);
    }

    public DpeConfig(boolean bl, int n, int n2, int n3, float f, int n4, int n5, int n6, float f2, int n7, boolean bl2, HistoryTimer historyTimer) {
        this.writeToFile = bl;
        this.maxConsecutiveFailures = n;
        this.historySize = n2;
        this.internalHistorySize = n3;
        this.autoThresholdLevel = f;
        this.minTimeBetweenSaves = n4;
        this.maxTimeBetweenSaves = n5;
        this.validSampleInterval = n6;
        this.historyThreshold = f2;
        this.maxNotifyListSize = n7;
        this.sendHistoryWithEvent = bl2;
        if (historyTimer != null) {
            this.historyTimer = historyTimer;
            return;
        }
        this.historyTimer = new HistoryTimer();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("DPE Configuration:\n");
        stringBuffer.append(" save History to file : ");
        stringBuffer.append(this.writeToFile);
        stringBuffer.append("\n");
        stringBuffer.append(" maximum consecutive failures = ");
        stringBuffer.append(this.maxConsecutiveFailures);
        stringBuffer.append("\n");
        stringBuffer.append(" number of data points stored per instance = ");
        stringBuffer.append(this.historySize);
        stringBuffer.append("\n");
        stringBuffer.append(" number of volatile data points stored per instance in memory = ");
        stringBuffer.append(this.internalHistorySize);
        stringBuffer.append("\n");
        stringBuffer.append(" auto threshold level = ");
        stringBuffer.append(this.autoThresholdLevel);
        stringBuffer.append("\n");
        stringBuffer.append(" minimum time between file writes = ");
        stringBuffer.append(this.minTimeBetweenSaves);
        stringBuffer.append("\n");
        stringBuffer.append(" maximum time between file writes = ");
        stringBuffer.append(this.maxTimeBetweenSaves);
        stringBuffer.append("\n");
        stringBuffer.append(" valid sample interval before threshold analysis = ");
        stringBuffer.append(this.validSampleInterval);
        stringBuffer.append("\n");
        stringBuffer.append(" history threshold = ");
        stringBuffer.append(this.historyThreshold);
        stringBuffer.append("\n");
        stringBuffer.append(" maximum number of pending notifications stored = ");
        stringBuffer.append(this.maxNotifyListSize);
        stringBuffer.append(" send history with event = ");
        stringBuffer.append(this.sendHistoryWithEvent);
        stringBuffer.append("\n");
        if (this.historyTimer != null) {
            Long l = this.historyTimer.getNextTimeToForwardHistory();
            if (l != null) {
                stringBuffer.append(" forward data history in ");
                stringBuffer.append(l / 60000L);
                stringBuffer.append(" minutes");
                stringBuffer.append("\n");
            } else {
                stringBuffer.append(" forward data history only when threshold reached");
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }
}

